<?php
// /api/lista_apps.php

header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');

try {
    $dbPath = __DIR__ . '/max.db';

    // Verifica se o banco de dados existe
    if (!file_exists($dbPath)) {
        throw new Exception("Banco de dados não encontrado.");
    }

    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Verifica se a tabela existe
    $stmt = $db->query("SELECT name, package, apk_url, icon_url FROM apps");

    $apps = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($apps) {
        echo json_encode($apps, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    } else {
        echo json_encode([], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }

} catch (Exception $e) {
    http_response_code(500); // Código de erro HTTP
    echo json_encode(["error" => $e->getMessage()], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
