<?php
include "../includes/header3.php";
?>
<style>
  .custom-button {
    padding: 10px 20px;
  }
  
  /* Container das imagens */
  .image-row {
    display: flex;
    flex-wrap: wrap; /* Permite que os itens quebrem para a próxima linha */
    justify-content: center;
    gap: 20px; /* Espaço entre as imagens */
  }

  /* Estilização das imagens */
  .image-container {
    text-align: center; /* Centraliza o texto */
    max-width: 100%;
  }

  .image-container img {
    width: 100%; /* Ajusta automaticamente */
    max-width: 300px; /* Mantém um limite máximo */
    height: auto;
  }

  /* Responsividade para telas menores */
  @media (max-width: 768px) {
    .image-row {
      flex-direction: column; /* Alinha verticalmente */
      align-items: center;
    }
  }

</style>

<div class="container-fluid">
    <h1 class="h3 mb-1 text-gray-800">Temas</h1>
    
    <div class="card border-left-primary shadow h-100 card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary2"><i class="fa fa-cogs"></i> Escolher</h6>
        </div>
        
        <div class="card-body">
            <?php
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $selectedOption = $_POST['options'];
                echo "Você selecionou: " . $selectedOption;

                $jsonData = file_get_contents("../a/rtx/Setting_$seller_name.json");
                $data = json_decode($jsonData, true);

                $data[0]["RTXSetting"] = "mLayout";
                $data[0]["PanalData"] = $selectedOption;

                $jsonData = json_encode($data, JSON_PRETTY_PRINT);
                file_put_contents("../a/rtx/Setting_$seller_name.json", $jsonData);
            }
            ?>

            <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <select name="options" id="options">
                    <option value="theme_d">Tema 1</option>
                    <option value="theme_2">Tema 2</option>
                    <option value="theme_3">Tema 3</option>
                    <option value="theme_5">Tema 5</option>
                </select>
                <br><br>
                <input type="submit" class="btn btn-success btn-icon-split" value=" Submit ">
            </form>
            
            <?php 
            $jsonData = file_get_contents("../a/rtx/Setting_$seller_name.json");
            $data = json_decode($jsonData, true);
            $current_layout = $data[0]["PanalData"];
            echo "<br><p style='text-align: center;'>Tema atual: $current_layout</p><br>";
            ?>

            <div class="image-row">
                <div class="image-container">
                    <p>TEMA 1</p>
                    <img src="../rtx/layout/d.png" alt="Tema 1">
                </div>

                <div class="image-container">
                    <p>TEMA 2</p>
                    <img src="../rtx/layout/2.png" alt="Tema 2">
                </div>   

                <div class="image-container">
                    <p>TEMA 3</p>
                    <img src="../rtx/layout/3.png" alt="Tema 3">
                </div>

                <div class="image-container">
                    <p>TEMA 5</p>
                    <img src="../rtx/layout/5.png" alt="Tema 5">
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include "../includes/footer3.php";
?>
