<?php
// Função para codificar os URLs das imagens
function codificarURL($url) {
    return base64_encode($url);
}

// Função para decodificar os URLs das imagens
function decodificarURL($urlCodificado) {
    return base64_decode($urlCodificado);
}

// Se um link oculto para imagem for acessado, redirecionar para a URL real
if (isset($_GET['img'])) {
    $url = decodificarURL($_GET['img']);
    header("Location: $url");
    exit;
}

// Função para gerar JavaScript para decodificação de imagens
function gerarScriptDecodificacao($imagens) {
    $script = "<script>\n";
    $script .= "document.addEventListener('DOMContentLoaded', function() {\n";
    foreach ($imagens as $id => $codificado) {
        $script .= "  document.getElementById('$id').src = atob('$codificado');\n";
    }
    $script .= "});\n";
    $script .= "</script>\n";
    return $script;
}

// Gerar um array para armazenar as imagens e seus IDs
$imagens = [];
$contadorImg = 0;

// Função para substituir src de img e adicionar ao array
function ocultarLinksDeImagensNoHTML($html) {
    global $imagens, $contadorImg;
    return preg_replace_callback(
        '/src=["\'](https:\/\/.*?)["\']/i',
        function($matches) use (&$imagens, &$contadorImg) {
            $urlCodificado = codificarURL($matches[1]);
            $idImagem = 'img' . $contadorImg++;
            $imagens[$idImagem] = $urlCodificado;
            return 'id="' . $idImagem . '" src="#"';
        },
        $html
    );
}

// Iniciar o buffer de saída
ob_start();

// Configurar o timezone
date_default_timezone_set('America/Sao_Paulo');

// Obter a data atual
$diaSemana = array(
    'Sunday' => 'Domingo',
    'Monday' => 'Segunda-feira',
    'Tuesday' => 'Terça-feira',
    'Wednesday' => 'Quarta-feira',
    'Thursday' => 'Quinta-feira',
    'Friday' => 'Sexta-feira',
    'Saturday' => 'Sábado'
);
$meses = array(
    'January' => 'Janeiro',
    'February' => 'Fevereiro',
    'March' => 'Março',
    'April' => 'Abril',
    'May' => 'Maio',
    'June' => 'Junho',
    'July' => 'Julho',
    'August' => 'Agosto',
    'September' => 'Setembro',
    'October' => 'Outubro',
    'November' => 'Novembro',
    'December' => 'Dezembro'
);

$data = new DateTime();
$diaSemanaPort = $diaSemana[$data->format('l')];
$dia = $data->format('d');
$mesPort = $meses[$data->format('F')];
$dataAtual = "$diaSemanaPort, $dia de $mesPort";
// URL do JSON de jogos
$json_url = 'https://MEUDOMINIO/jogos_do_dia.json';

// Obtém o conteúdo do JSON
$json_content = file_get_contents($json_url);

// Decodifica o JSON
$jogos = json_decode($json_content, true);
?>
<?php
session_start();

// Caminho do arquivo JSON
$jsonFile = 'config.json';

// Verifica se o arquivo JSON existe, se não, cria o arquivo com cores padrão
if (!file_exists($jsonFile)) {
    $defaultColors = [
        'color1' => '#000000',
        'color2' => '#f50057'
    ];
    file_put_contents($jsonFile, json_encode($defaultColors));
}

// Verifica se as cores foram enviadas via GET e atualiza o arquivo JSON
if (isset($_GET['color1']) && isset($_GET['color2'])) {
    $colors = [
        'color1' => $_GET['color1'],
        'color2' => $_GET['color2']
    ];
    file_put_contents($jsonFile, json_encode($colors));  // Salva as cores no arquivo JSON
}

// Lê o arquivo JSON para obter as cores
$colors = json_decode(file_get_contents($jsonFile), true);
$color1 = isset($colors['color1']) ? $colors['color1'] : '#000000';
$color2 = isset($colors['color2']) ? $colors['color2'] : '#f50057';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jogos do Dia</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #141414;
            color: white;
            margin: 0;
            padding: 0;
        }
        .container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
            padding: 20px;
        }
        .jogo-card {
            background: linear-gradient(145deg, <?php echo htmlspecialchars($color1); ?>, <?php echo htmlspecialchars($color2); ?>);
            border-radius: 30px;
            width: 250px;
            padding: 10px;
            margin-bottom: 30px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            text-align: center;
            position: relative;
        }
        .times {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px;
            position: relative;
            top: -40px;
        }
        .time-box {
            background: linear-gradient(145deg, <?php echo htmlspecialchars($color1); ?>, <?php echo htmlspecialchars($color2); ?>);
            border-radius: 40px;
            padding: 18px;
            width: 250px;
            height: 110px;
            text-align: center;
            color: white;
            box-shadow: 0 3px 5px rgba(0, 0, 0, 0.3);
            position: relative;
           animation: glowing 5s infinite alternate;
        }
        @keyframes glowing {
            0% {
                filter: brightness(1);
                box-shadow: 0 3px 5px rgba(0, 0, 0, 0.3);
            }
            50% {
                filter: brightness(1.5);
                box-shadow: 0 5px 15px rgba(245, 0, 87, 0.6), 0 5px 15px rgba(0, 0, 0, 0.6);
            }
            100% {
                filter: brightness(1);
                box-shadow: 0 3px 5px rgba(0, 0, 0, 0.3);
            }
        }
        .time img {
            width: 70px;
            height: 70px;
            object-fit: contain;
            display: block;
            margin: 0 auto;
        }
        .time p {
            margin: 5px 0 0 0;
            font-size: 15px;
            font-weight: bold;
            color: white;
        }
        .vs img {
            width: 40px;
            height: auto;
            object-fit: contain;
        }
        .hora {
            font-size: 35px;
            margin: 10px 0;
            font-weight: bold;
            color: #ffffff;
        }
        .campeonato {
            font-size: 15px;
            margin-top: -32px;
            font-weight: bold;
            color: #ffffff;
        }
        .canais {
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        .canal-box {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 5px 10px;
            border: 1px solid #ccc;
            border-radius: 10px;
            background-color: white;
            color: black;
            font-weight: bold;
            min-width: 100px; /* Tamanho mínimo da caixa */
            height: 20px; /* Altura fixa */
        }
        .canal-box img {
            width: 25px;
            height: 25px;
            margin-right: 5px;
            object-fit: contain;
        }
        .canal-box p {
            margin: 0;
            font-size: 14px;
            color: black;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 100;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
        }
        .modal-content {
            background-color: #333;
            margin: 15% auto;
            padding: 20px;
            border-radius: 10px;
            width: 300px;
            text-align: center;
            color: white;
        }
        .close-btn {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
        .close-btn:hover {
            color: white;
            cursor: pointer;
        }
        .btn-salvar {
            background-color: #28a745;
            border: none;
            color: white;
            padding: 10px 20px;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
        }
        .btn-salvar:hover {
            background-color: #218838;
        }
        .star-button {
            font-size: 24px;
            cursor: pointer;
            color: gold;
            border: none;
            background: none;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <h1 style="text-align: center;">
        <button class="star-button" onclick="openModal()">&#9733;</button>
        Jogos De Hoje <?php echo $dataAtual; ?>
        <button class="star-button" onclick="openModal()">&#9733;</button>
    </h1>

    <!-- Modal para mudar as cores -->
    <div id="modal" class="modal">
        <div class="modal-content">
            <span class="close-btn" onclick="closeModal()">&times;</span>
            <h2>Mudar Cores</h2>
            <form method="GET" action="">
                <label for="color1">Cor 1: </label>
                <input type="color" id="color1" name="color1" value="<?php echo htmlspecialchars($color1); ?>"><br><br>

                <label for="color2">Cor 2: </label>
                <input type="color" id="color2" name="color2" value="<?php echo htmlspecialchars($color2); ?>"><br><br>

                <button type="submit" class="btn-salvar">Salvar Cores</button>
            </form>
        </div>
    </div>

    <div class="container">
        <!-- Exibição dos jogos -->
        <?php foreach ($jogos as $jogo): ?>
        <div class="jogo-card">
            <div class="times">
                <div class="time-box">
                    <div class="time">
                        <img src="<?= $jogo['logo1']; ?>" alt="<?= $jogo['time1']; ?>">
                        <p><?= $jogo['time1']; ?></p>
                    </div>
                </div>
                <div class="vs">
                    <img src="https://pic.onlinewebfonts.com/thumbnails/icons_418591.svg" alt="Versus">
                </div>
                <div class="time-box">
                    <div class="time">
                        <img src="<?= $jogo['logo2']; ?>" alt="<?= $jogo['time2']; ?>">
                        <p><?= $jogo['time2']; ?></p>
                    </div>
                </div>
            </div>
            <div class="campeonato"><?= $jogo['campeonato']; ?></div>
            <div class="hora"><?= $jogo['hora']; ?></div>
            <div class="canais">
                <?php foreach ($jogo['canal_logos'] as $canal): ?>
                <div class="canal-box">
                    <img src="<?= $canal['logo']; ?>" alt="<?= $canal['nome']; ?>">
                    <p><?= $canal['nome']; ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <script>
        // Função para abrir o modal
        function openModal() {
            document.getElementById('modal').style.display = 'block';
        }

        // Função para fechar o modal
        function closeModal() {
            document.getElementById('modal').style.display = 'none';
        }

        // Fecha o modal quando clicar fora dele
        window.onclick = function(event) {
            var modal = document.getElementById('modal');
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
    </script>
</body>
</html>

