<?php
// Configurações do banco de dados
$host = 'localhost';
$dbname = 'DDDD';
$user = 'DDDDD';
$pass = 'DDDD';

// Configurações do Telegram
$telegramToken = 'TOKENNN';
$chatId = 'GRUPOOO'; // Pode ser o ID de um grupo, canal ou chat individual

// Gerando o nome do arquivo de backup
$backupFile = 'backup/backup_' . date('Y-m-d_H-i-s') . '.sql';
$zipFile = 'backup/backup_' . date('Y-m-d_H-i-s') . '.zip';

// Comando para realizar o backup (mysqldump)
$command = "mysqldump --user={$user} --password={$pass} --host={$host} {$dbname} > {$backupFile}";
system($command, $output);

// Verificando se o backup foi criado
if (file_exists($backupFile)) {
    // Criando arquivo ZIP
    $zip = new ZipArchive();
    if ($zip->open($zipFile, ZipArchive::CREATE) === TRUE) {
        $zip->addFile($backupFile, basename($backupFile));
        $zip->close();

        // Enviando o arquivo ZIP para o Telegram
        $url = "https://api.telegram.org/bot{$telegramToken}/sendDocument";
        
        $post_fields = [
            'chat_id' => $chatId,
            'document' => new CURLFile(realpath($zipFile)),
            'caption' => 'Backup do banco de dados realizado com sucesso.'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type:multipart/form-data"]);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
        $result = curl_exec($ch);
        curl_close($ch);

        // Excluindo os arquivos de backup após enviar (opcional)
        unlink($backupFile);
        unlink($zipFile);
        
        echo "Backup realizado e enviado com sucesso.";
    } else {
        echo "Falha ao criar o arquivo ZIP.";
    }
} else {
    echo "Falha ao criar o backup.";
}
?>