<?php
include 'auth.php'; // Arquivo de autenticação
include 'db.php'; // Conexão com o banco de dados

// Função para carregar campeonatos do banco de dados
function carregarCampeonatos($conn) {
    $sql = "SELECT * FROM campeonatos";
    $result = mysqli_query($conn, $sql);
    return mysqli_fetch_all($result, MYSQLI_ASSOC);
}

// Lidar com ações de exclusão e edição
if (isset($_GET['excluir'])) {
    $id = $_GET['excluir'];
    $sql = "DELETE FROM campeonatos WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    header("Location: cadastro_campeonato.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nome = $_POST['nome'];
    $acao = $_POST['acao'];

    if ($acao == "criar") {
        $sql = "INSERT INTO campeonatos (nome) VALUES (?)";
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, 's', $nome);
        mysqli_stmt_execute($stmt);
    } elseif ($acao == "editar") {
        $id = $_POST['id'];
        $sql = "UPDATE campeonatos SET nome = ? WHERE id = ?";
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, 'si', $nome, $id);
        mysqli_stmt_execute($stmt);
    }

    header("Location: cadastro_campeonato.php");
    exit();
}

$campeonatos = carregarCampeonatos($conn);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro de Campeonato</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 1200px;
            display: flex;
            justify-content: space-between;
        }
        .form-container {
            width: 48%;
        }
        .list-container {
            width: 48%;
            max-height: 400px;
            overflow-y: auto;
        }
        h1 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
            text-align: center;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        .button-group {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }
        button {
            background-color: #5cb85c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin-right: 10px;
        }
        button:hover {
            background-color: #4cae4c;
        }
        .home-button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-left: 10px;
        }
        .home-button:hover {
            background-color: #0056b3;
        }
        .list-item {
            background-color: #fff;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .list-item div {
            flex-grow: 1;
        }
        .list-item button {
            background-color: #d9534f;
            margin-left: 10px;
        }
        .list-item button:hover {
            background-color: #c9302c;
        }
    </style>
</head>
<body>

<div class="container">

    <div class="form-container">
        <h1><?php echo isset($_GET['editar']) ? 'Editar Campeonato' : 'Cadastro de Campeonato'; ?></h1>
        <form method="POST" action="cadastro_campeonato.php">
            <input type="text" name="nome" placeholder="Digite o nome do campeonato" value="<?php echo isset($_GET['editar']) ? htmlspecialchars($campeonatos[$_GET['editar']]['nome']) : ''; ?>" required>
            <?php if (isset($_GET['editar'])): ?>
                <input type="hidden" name="id" value="<?php echo $campeonatos[$_GET['editar']]['id']; ?>">
                <div class="button-group">
                    <button type="submit" name="acao" value="editar">Salvar Alterações</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php else: ?>
                <div class="button-group">
                    <button type="submit" name="acao" value="criar">Cadastrar Campeonato</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php endif; ?>
        </form>
    </div>

    <div class="list-container">
        <h1>Campeonatos Cadastrados</h1>
        <?php if (empty($campeonatos)): ?>
            <p>Nenhum campeonato cadastrado.</p>
        <?php else: ?>
            <?php foreach ($campeonatos as $index => $campeonato): ?>
                <div class="list-item">
                    <div><?php echo htmlspecialchars($campeonato['nome']); ?></div>
                    <div>
                        <a href="cadastro_campeonato.php?editar=<?php echo $index; ?>"><button>Editar</button></a>
                        <a href="cadastro_campeonato.php?excluir=<?php echo $campeonato['id']; ?>"><button>Excluir</button></a>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
