<?php
// Função para codificar os URLs das imagens
function codificarURL($url) {
    return base64_encode($url);
}

// Função para decodificar os URLs das imagens
function decodificarURL($urlCodificado) {
    return base64_decode($urlCodificado);
}

// Se um link oculto para imagem for acessado, redirecionar para a URL real
if (isset($_GET['img'])) {
    $url = decodificarURL($_GET['img']);
    header("Location: $url");
    exit;
}

// Função para gerar JavaScript para decodificação de imagens
function gerarScriptDecodificacao($imagens) {
    $script = "<script>\n";
    $script .= "document.addEventListener('DOMContentLoaded', function() {\n";
    foreach ($imagens as $id => $codificado) {
        $script .= "  document.getElementById('$id').src = atob('$codificado');\n";
    }
    $script .= "});\n";
    $script .= "</script>\n";
    return $script;
}

// Gerar um array para armazenar as imagens e seus IDs
$imagens = [];
$contadorImg = 0;

// Função para substituir src de img e adicionar ao array
function ocultarLinksDeImagensNoHTML($html) {
    global $imagens, $contadorImg;
    return preg_replace_callback(
        '/src=["\'](https:\/\/.*?)["\']/i',
        function($matches) use (&$imagens, &$contadorImg) {
            $urlCodificado = codificarURL($matches[1]);
            $idImagem = 'img' . $contadorImg++;
            $imagens[$idImagem] = $urlCodificado;
            return 'id="' . $idImagem . '" src="#"';
        },
        $html
    );
}

// Iniciar o buffer de saída
ob_start();

// Configurar o timezone
date_default_timezone_set('America/Sao_Paulo');

// Carregar o arquivo JSON com jogos
$jsonData = file_get_contents('https://MEUDOMINIO/jogos_do_dia.json');
$jogos = json_decode($jsonData, true);

// Obter a data atual
$diaSemana = array(
    'Sunday' => 'Domingo',
    'Monday' => 'Segunda-feira',
    'Tuesday' => 'Terça-feira',
    'Wednesday' => 'Quarta-feira',
    'Thursday' => 'Quinta-feira',
    'Friday' => 'Sexta-feira',
    'Saturday' => 'Sábado'
);
$meses = array(
    'January' => 'Janeiro',
    'February' => 'Fevereiro',
    'March' => 'Março',
    'April' => 'Abril',
    'May' => 'Maio',
    'June' => 'Junho',
    'July' => 'Julho',
    'August' => 'Agosto',
    'September' => 'Setembro',
    'October' => 'Outubro',
    'November' => 'Novembro',
    'December' => 'Dezembro'
);

$data = new DateTime();
$diaSemanaPort = $diaSemana[$data->format('l')];
$dia = $data->format('d');
$mesPort = $meses[$data->format('F')];
$dataAtual = "$diaSemanaPort, $dia de $mesPort";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jogos do Dia</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            padding: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh; /* Garante que o conteúdo seja exibido em tela cheia */
            overflow: hidden; /* Remove a rolagem automática */
        }
        .logo {
            max-width: 300px;
            margin-bottom: 20px;
        }
        .jogos-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); /* Ajuste para colunas responsivas */
            gap: 20px;
            width: 100%;
            max-width: 1200px;
            justify-content: center;
            overflow-y: auto; /* Permite rolagem manual dentro do container */
        }
        .jogo-card {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 15px;
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
        }
        .jogo-card:focus {
            outline: 2px solid #28a745; /* Realça o foco no card */
            transform: scale(1.05); /* Aumenta ligeiramente o tamanho do card ao focar */
        }
        .jogo-card h1 {
            font-size: 16px;
            color: #004080;
            margin-bottom: 5px;
        }
        .campeonato {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            margin-bottom: 15px;
        }
        .jogo-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            margin-bottom: 10px;
            position: relative;
        }
        .time {
            display: flex;
            align-items: center;
            flex-direction: column;
        }
        .time img {
            width: 70px; /* Ajuste de largura */
            height: auto;
            margin-bottom: 5px;
            object-fit: contain;
        }
        .time-nome {
            font-weight: bold;
            font-size: 14px;
            color: #333;
            text-align: center;
        }
        .vs-hora-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .vs img {
            width: 70px; /* Ajuste de largura */
            height: auto;
            object-fit: contain;
        }
        .hora {
            font-size: 20px;
            font-weight: bold;
            color: #28a745;
            text-align: center;
            margin-top: 5px;
        }
        .canal {
            display: flex;
            justify-content: center;
            margin-top: 10px;
        }
        .canal-box {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 5px 10px;
            border: 1px solid #ccc;
            border-radius: 12px;
            background-color: white;
            color: black;
            font-weight: bold;
            min-width: 100px;
            height: 20px;
            margin: 0 5px;
        }
        .canal-box img {
            width: 25px;
            height: 25px;
            margin-right: 5px;
            object-fit: contain;
        }
        .transmissao {
            color: #d9534f;
            font-weight: bold;
            margin-top: 15px;
        }
        .mensagem-aviso {
            font-size: 16px;
            font-weight: bold;
            color: white;
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<img src="https://i.imgur.com/ZkAc2hy.png" alt="Logo" class="logo">

<div class="jogos-container" tabindex="0"> <!-- Adicionado tabindex para permitir foco -->
    <?php foreach ($jogos as $index => $jogo): ?>
        <div class="jogo-card" tabindex="<?php echo $index + 1; ?>"> <!-- Adicionado tabindex para cada card -->
            <h1><?php echo $dataAtual; ?></h1>
            <div class="campeonato"><?php echo htmlspecialchars($jogo['campeonato']); ?></div>
            <div class="jogo-info">
                <div class="time">
                    <img src="<?php echo htmlspecialchars($jogo['logo1']); ?>" alt="<?php echo htmlspecialchars($jogo['time1']); ?> Logo">
                    <div class="time-nome"><?php echo htmlspecialchars($jogo['time1']); ?></div>
                </div>
                <div class="vs-hora-container">
                    <div class="vs">
                        <img src="https://i.imgur.com/WcT6FXq.png" alt="Versus">
                    </div>
                    <div class="hora"><?php echo htmlspecialchars($jogo['hora']); ?></div>
                </div>
                <div class="time">
                    <img src="<?php echo htmlspecialchars($jogo['logo2']); ?>" alt="<?php echo htmlspecialchars($jogo['time2']); ?> Logo">
                    <div class="time-nome"><?php echo htmlspecialchars($jogo['time2']); ?></div>
                </div>
            </div>
            <div class="canal">
                <?php if (count($jogo['canal_logos']) > 0): ?>
                    <?php foreach ($jogo['canal_logos'] as $canal): ?>
                        <div class="canal-box">
                            <img src="<?php echo htmlspecialchars($canal['logo']); ?>" alt="<?php echo htmlspecialchars($canal['nome']); ?> Logo">
                            <div><?php echo htmlspecialchars($canal['nome']); ?></div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="transmissao">Transmissão não disponível</div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<div class="mensagem-aviso">
    COMPARTILHAR API SPORT OU VENDA NÃO AUTORIZADA SERÁ FEITO O BLOQUEIO E SEM DIREITO DE REEMBOLSO
</div>

<script>
    // Script para permitir a navegação pelos cards utilizando os botões direcionais
    document.addEventListener('keydown', function(event) {
        let focusedElement = document.activeElement;
        let cards = document.querySelectorAll('.jogo-card');
        let index = Array.from(cards).indexOf(focusedElement);

        switch (event.key) {
            case 'ArrowRight':
                if (index < cards.length - 1) {
                    cards[index + 1].focus();
                }
                break;
            case 'ArrowLeft':
                if (index > 0) {
                    cards[index - 1].focus();
                }
                break;
            case 'ArrowDown':
                if (index < cards.length - 1) {
                    cards[index + 1].focus();
                }
                break;
            case 'ArrowUp':
                if (index > 0) {
                    cards[index - 1].focus();
                }
                break;
        }
    });
</script>

</body>
</html>

<?php
// Processar o conteúdo do buffer de saída e ocultar os links de imagens
$html = ob_get_clean();
$html = ocultarLinksDeImagensNoHTML($html);
echo $html;

// Gerar e inserir o script de decodificação no final do HTML
echo gerarScriptDecodificacao($imagens);
?>
